﻿//////////////////////////////////////////////
// QuaternionWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkMathsWrap
{
	class DLL_ASTRAEUS_EXPORT QuaternionWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Construction / destruction
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			static nkScripts::OutputValue newQuat4 (const nkScripts::DataStack& stack) ;
			// Getters
			static nkScripts::OutputValue getAsEulerAngles (const nkScripts::DataStack& stack) ;
			// Applications
			static nkScripts::OutputValue transform (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue apply (const nkScripts::DataStack& stack) ;
			// Conversion
			static nkScripts::OutputValue setFromAxisAngle (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setFromEuler (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setFromRotationBetween (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setFromOrientationMatrix (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setFromTransformationMatrix (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue toString (const nkScripts::DataStack& stack) ;
			// Operators
			static nkScripts::OutputValue add (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue sub (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue mul (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue div (const nkScripts::DataStack& stack) ;
			// Logical
			static nkScripts::OutputValue eq (const nkScripts::DataStack& stack) ;
	} ;
}